/*!
  * Outweave Themes (https://outweave.com/)
*/

document.addEventListener("DOMContentLoaded", function(event) {
    if (typeof Swiper !== 'undefined') {
        var slider2 = new Swiper(".slider-4", {
            navigation: {
                nextEl: ".swiper-button-next",
                prevEl: ".swiper-button-prev",
            },
            autoplay: {
                delay: 5000,
            },
            loop: true,
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
        });
        var testimonial1 = new Swiper(".testimonial-slider-1", {
            slidesPerView: 1,
            loop: true,
            autoplay: {
                delay: 3000,
            },
            breakpoints: {
                576: {
                    slidesPerView: 1,
                },
                992: {
                    slidesPerView: 2,
                },
            },
        });
        var brands1 = new Swiper(".brand-slider-1", {
            spaceBetween: 15,
            breakpoints: {
                0: {
                    slidesPerView: 2,
                },
                768: {
                    slidesPerView: 3,
                },
                992: {
                    slidesPerView: 4,
                },
                1200: {
                    slidesPerView: 5,
                },
            },
            autoplay: {
                delay: 2000,
            },
            loop: true,
        });
    }
    if (typeof GLightbox !== 'undefined') {
        var lightbox = GLightbox({
            selector: '.glightbox'
        });
    }
    if (document.querySelector(".contact-form")) {
        document.forms["contact-form"].addEventListener("submit", function(e) {
            e.preventDefault();
            document.getElementsByClassName('loader')[0].style.display = 'flex';
            var name = encodeURIComponent(document.getElementById("name").value);
            var email = encodeURIComponent(document.getElementById("email").value);
            var phone = encodeURIComponent(document.getElementById("phone").value);
            var message = encodeURIComponent(document.getElementById("message").value);
            var captcha_code = encodeURIComponent(document.getElementById("captcha_code").value);

            if(name == "" || email == "" || phone == "" || message == ""){
                document.getElementById("response").innerHTML = "<p>Some of the fields are empty!</p>";
                document.getElementById("response").style.display = "block";
                return;
            }

            var params = "name=" + name + "&email=" + email + "&phone=" + phone + "&message=" + message +"&captcha_code=" + captcha_code;
            var http = new XMLHttpRequest();
            http.open("POST","php/send.php",true);
            http.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            http.onreadystatechange = function() {
                if(http.readyState == 4 && http.status == 200) {
                    document.getElementById("captcha_refresh_button").click();
                    document.getElementsByClassName('loader')[0].style.display = 'none';
                    document.getElementById("response").innerHTML = http.responseText;
                    document.getElementById("response").style.display = "block";
                }
            }
            http.send(params);
        });
    }
    document.getElementById('copyright-year').textContent = new Date().getFullYear();
});